/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.container.PhilosStoneContainer;
import moze_intel.projecte.gameObjs.entity.EntityMobRandomizer;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhilosophersStone
extends ItemMode
implements IProjectileShooter,
IExtraFunction {
    public PhilosophersStone(Item.Properties props) {
        super(props, 4, PELang.MODE_PHILOSOPHER_1, PELang.MODE_PHILOSOPHER_2, PELang.MODE_PHILOSOPHER_3);
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.m_41777_();
    }

    public BlockHitResult getHitBlock(Player player) {
        return PhilosophersStone.m_41435_((Level)player.m_20193_(), (Player)player, (ClipContext.Fluid)(player.m_6144_() ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Map<BlockPos, BlockState> toChange;
        Player player = ctx.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = ctx.m_8083_();
        Direction sideHit = ctx.m_43719_();
        Level level = ctx.m_43725_();
        ItemStack stack = ctx.m_43722_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockHitResult rtr = this.getHitBlock(player);
        if (rtr.m_6662_() == HitResult.Type.BLOCK && !rtr.m_82425_().equals((Object)pos)) {
            pos = rtr.m_82425_();
            sideHit = rtr.m_82434_();
        }
        if (!(toChange = PhilosophersStone.getChanges(level, pos, player, sideHit, this.getMode(stack), this.getCharge(stack))).isEmpty()) {
            for (Map.Entry<BlockPos, BlockState> entry : toChange.entrySet()) {
                BlockPos currentPos = entry.getKey();
                PlayerHelper.checkedReplaceBlock((ServerPlayer)player, currentPos, entry.getValue());
                if (level.f_46441_.nextInt(8) != 0) continue;
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)currentPos.m_123341_(), (double)(currentPos.m_123342_() + 1), (double)currentPos.m_123343_(), 2, 0.0, 0.0, 0.0, 0.0);
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.TRANSMUTE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean shootProjectile(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        Level level = player.m_20193_();
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.TRANSMUTE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        EntityMobRandomizer ent = new EntityMobRandomizer(player, level);
        ent.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
        level.m_7967_((Entity)ent);
        return true;
    }

    @Override
    public boolean doExtraFunction(@NotNull ItemStack stack, @NotNull Player player, InteractionHand hand) {
        if (!player.m_20193_().f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ContainerProvider(stack));
        }
        return true;
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltips, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        tooltips.add((Component)PELang.TOOLTIP_PHILOSTONE.translate(ClientKeyHelper.getKeyName(PEKeybind.EXTRA_FUNCTION)));
    }

    public static Map<BlockPos, BlockState> getChanges(Level level, BlockPos pos, Player player, Direction sideHit, int mode, int charge) {
        boolean isSneaking;
        BlockState targeted = level.m_8055_(pos);
        BlockState result = WorldTransmutations.getWorldTransmutation(targeted, isSneaking = player.m_6144_());
        if (result == null) {
            return Collections.emptyMap();
        }
        Stream stream = null;
        switch (mode) {
            case 0: {
                stream = BlockPos.m_121990_((BlockPos)pos.m_142082_(-charge, -charge, -charge), (BlockPos)pos.m_142082_(charge, charge, charge));
                break;
            }
            case 1: {
                if (sideHit == Direction.UP || sideHit == Direction.DOWN) {
                    stream = BlockPos.m_121990_((BlockPos)pos.m_142082_(-charge, 0, -charge), (BlockPos)pos.m_142082_(charge, 0, charge));
                    break;
                }
                if (sideHit == Direction.EAST || sideHit == Direction.WEST) {
                    stream = BlockPos.m_121990_((BlockPos)pos.m_142082_(0, -charge, -charge), (BlockPos)pos.m_142082_(0, charge, charge));
                    break;
                }
                if (sideHit != Direction.SOUTH && sideHit != Direction.NORTH) break;
                stream = BlockPos.m_121990_((BlockPos)pos.m_142082_(-charge, -charge, 0), (BlockPos)pos.m_142082_(charge, charge, 0));
                break;
            }
            case 2: {
                Direction playerFacing = player.m_6350_();
                if (playerFacing.m_122434_() == Direction.Axis.Z) {
                    stream = BlockPos.m_121990_((BlockPos)pos.m_142082_(0, 0, -charge), (BlockPos)pos.m_142082_(0, 0, charge));
                    break;
                }
                if (playerFacing.m_122434_() != Direction.Axis.X) break;
                stream = BlockPos.m_121990_((BlockPos)pos.m_142082_(-charge, 0, 0), (BlockPos)pos.m_142082_(charge, 0, 0));
            }
        }
        if (stream == null) {
            return Collections.emptyMap();
        }
        Object2ObjectArrayMap conversions = new Object2ObjectArrayMap();
        conversions.put(targeted, result);
        HashMap<BlockPos, BlockState> changes = new HashMap<BlockPos, BlockState>();
        Block targetBlock = targeted.m_60734_();
        stream.forEach(arg_0 -> PhilosophersStone.lambda$getChanges$0(level, targetBlock, (Map)conversions, isSneaking, changes, arg_0));
        return changes;
    }

    private static /* synthetic */ void lambda$getChanges$0(Level level, Block targetBlock, Map conversions, boolean isSneaking, Map changes, BlockPos currentPos) {
        BlockState state = level.m_8055_(currentPos);
        if (state.m_60713_(targetBlock)) {
            BlockState actualResult;
            if (conversions.containsKey(state)) {
                actualResult = (BlockState)conversions.get(state);
            } else {
                actualResult = WorldTransmutations.getWorldTransmutation(state, isSneaking);
                conversions.put(state, actualResult);
            }
            if (actualResult != null) {
                changes.put(currentPos.m_7949_(), actualResult);
            }
        }
    }

    private record ContainerProvider(ItemStack stack) implements MenuProvider
    {
        @NotNull
        public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
            return new PhilosStoneContainer(windowId, playerInventory, ContainerLevelAccess.m_39289_((Level)player.m_20193_(), (BlockPos)player.m_142538_()));
        }

        @NotNull
        public Component m_5446_() {
            return this.stack.m_41786_();
        }
    }
}

